﻿/*
VERSION
	1.0

PUBLIC FUNCTIONS
	getCost		(externally-defined)		This sets the cost of each node, based on externally-defined criteria.
	getPath		This returns an array of objects containing x,y coordinates, from beginning to end.
	
SUPPORT FUNCTIONS
	makeNodeArray				This creates a new 2D-array of Node objects.	
	defineCost						This uses the passed "getCost" function to calculate the cost value of every node.
	closeNode						This closes the node  &  removes it from the "open" list.
	distance							This calculates the straight-line distance between 2 locations, passed as coordinates.
	calcNode						This calculates a node's 3 costs  &  adds it to the "open" list.
	calcNodesAround			This calculates the costs of surrounding nodes. (area / cross)
	findNode							This returns the node with the lowest value.  You specify which data member to measure.
	findSurroundingNode	This returns the node with the lowest value. (area / cross)
	
NODE VARIABLES
	x								// horz location in 2D array
	y								// vert location in 2D array
	costSoFar				// accumulated cost including current node  (g)
	distanceToEnd		// distance to destination  (h)
	totalCost				// costSoFar + distanceToEnd  (f)
	cost							// How unfavorable this node is.
	open						// Means that this node has been calculated & is being considered
	closed						// Excludes this node from consideration
*/






function getPath( startX, startY, endX, endY, width, height, getCost, allowDiagonal)
{
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
	// define "Node" object
	var Node = function(x,y){									// An object
		this.x = (x == null) ? -1 : x;										// horz location in 2D array
		this.y = (y == null) ? -1 : y;										// vert location in 2D array
	};
	Node.prototype.x = 0;											// horz location in 2D array
	Node.prototype.y = 0;											// vert location in 2D array
	Node.prototype.costSoFar = -1;							// accumulated cost including current node  (g)
	Node.prototype.distanceToEnd = -1;					// distance to destination  (h)
	Node.prototype.totalCost = -1;							// costSoFar + distanceToEnd  (f)
	Node.prototype.cost = 1;									// How unfavorable this node is.
	Node.prototype.open = false;							// Means that this node has been calculated & is being considered
	Node.prototype.closed = false;							// Excludes this node from consideration
	
	
	
	
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
	// Support functions
	var makeNodeArray = function(width, height)
	{
		var new_array = new Array();
		for (var x = 0; x < width; x++)
		{
			new_array[x] = new Array();
			for (var y = 0; y < height; y++)
			{
				new_array[x][y] = new Node(x,y);
			}// for y
		}// for x
		// - - - - - - - - - - - - 
		return new_array;
	}// makeNodeArray()
	
	
	
	var defineCost = function(array, getCost)
	{
		if (getCost)
		{
			for (var x = 0; x < width; x++)
			{
				for (var y = 0; y < height; y++)
				{
					var newCost = getCost(x,y);
					node_array[x][y].cost = newCost;
				}// for y
			}// for x
		}else{
			// no criteria
			trace("The cost criteria has NOT been defined!");
			trace("\tYou need to pass a function into aStar that translates collision into cost, based on (x,y) coordinates.");
			trace("\tIt's the 7th parameter of the getPath() function.");
		}// if (getCost)
	}// defineCost()
	
	
	
	var closeNode = function(thisNode)
	{
		thisNode.open = false;
		thisNode.closed = true;
		
		// remove this node from the "open" list.
		for (var i = 0; i < open_array.length; i++)
		{
			var checkNode = open_array[i];
			if (thisNode.x == checkNode.x  &&  thisNode.y == checkNode.y)
			{// node found
				// remove this node from the "open" list
				open_array.splice(i, 1);
				break;		// no need to keep looking
			}// if (node found)
		}// for (open_array.length)
		
	}// closeNode()

	
	
	var distance = function( startX, startY, endX, endY)
	{
		// pythagorean therom
		var diffX = startX - endX;
		var diffY = startY - endY;
		var distance = Math.sqrt( diffX*diffX + diffY*diffY );
		// - - - - - - - - - - - - 
		return distance;
	}// distance()
	
	
	
	var calcNode = function( thisNode, parentNode, endNode)
	{
		// calculate the costs
		thisNode.costSoFar = parentNode.totalCost + thisNode.cost;		// g
		thisNode.distanceToEnd = distance(thisNode.x, thisNode.y, endNode.x, endNode.y)		// h
		thisNode.totalCost = thisNode.costSoFar + thisNode.distanceToEnd;		// f
		
		// Add to "open" list
		thisNode.open = true;
		open_array.push(thisNode);
	}// calcNode()
	
	
	
	var calcNodesAround = function( parentNode, endNode, allowDiagonal)
	{
		var top = parentNode.y - 1;
		var bottom = parentNode.y + 1;
		var left = parentNode.x - 1;
		var right = parentNode.x + 1;
		// limit range
		top = (top<0) ? 0 : top;		// min = 0
		bottom = (bottom>=height) ? height-1 : bottom;		// max = height-1
		left = (left<0) ? 0 : left;		// min = 0
		right = (right>=width) ? width-1 : right;		// max = width-1

		if (allowDiagonal)
		{// calculate an area
			for (var x = left; x<=right; x++)
			{
				for (var y = top; y<=bottom; y++)
				{
					var thisNode = node_array[x][y];
					if (!thisNode.closed  &&  !thisNode.open)
					{// if thisNode hasn't been touched  (not closed nor open)
						calcNode( thisNode, parentNode, endNode );
					}// if thisNode hasn't been touched  (not closed nor open)
				}// for y
			}// for x
		}// if (allowDiagonal)
		else
		{// calculate in a cross
			var y = parentNode.y;
			for (var x = left; x<=right; x++)
			{
				var thisNode = node_array[x][y];
				if (!thisNode.closed  &&  !thisNode.open)
				{// if thisNode hasn't been touched  (not closed nor open)
					calcNode( thisNode, parentNode, endNode );
				}// if thisNode hasn't been touched  (not closed nor open)
			}// for x
			
			var x = parentNode.x;
			for (var y = top; y<=bottom; y++)
			{
				var thisNode = node_array[x][y];
				if (!thisNode.closed  &&  !thisNode.open)
				{// if thisNode hasn't been touched  (not closed nor open)
					calcNode( thisNode, parentNode, endNode );
				}// if thisNode hasn't been touched  (not closed nor open)
			}// for y
			
		}// if (!allowDiagonal)
	}// calcNodesAround()
	
	
	
	var findNode = function(array, checkVariable)
	{
		// look for the node with the lowest variable
		var lowestNode;
		var lowestValue = 9999;
		for (var thisIndex = 0; thisIndex < array.length; thisIndex++)
		{
			// get this node's variable
			var thisNode = array[thisIndex];
			var thisValue = thisNode[checkVariable];
			trace("x:"+thisNode.x+" y:"+thisNode.y+"  "+checkVariable+":"+thisValue);
			if (thisValue != -1)
			{
				// compare it
				if (thisValue < lowestValue)
				{
					lowestValue = thisValue;
					lowestNode = thisNode;
				}// if (thisValue < lowestValue)
			}// if (checkvariable != -1)
		}// for (array.length)
		
		// - - - - - - - - - - - - 
		return lowestNode;
	}// findNode()
	
	
	
	var findSurroundingNode = function( parentNode, allowDiagonal, array, checkVariable)
	{
		var lowestNode;
		var lowestValue = 9999;
		
		var top = parentNode.y - 1;
		var bottom = parentNode.y + 1;
		var left = parentNode.x - 1;
		var right = parentNode.x + 1;
		// limit range
		top = (top<0) ? 0 : top;		// min = 0
		bottom = (bottom>=height) ? height-1 : bottom;		// max = height-1
		left = (left<0) ? 0 : left;		// min = 0
		right = (right>=width) ? width-1 : right;		// max = width-1
		// - - - - - - - - - - - - 
		
		var compareNode = function()
		{
			var thisNode = array[x][y];
			// get this node's variable
			var thisValue = thisNode[checkVariable];
			if (thisValue != -1)
			{
				trace("x:"+thisNode.x+" y:"+thisNode.y+"  "+checkVariable+":"+thisValue);
				// compare it
				//thisNode.open = false;
				if (thisValue < lowestValue)
				{
					lowestValue = thisValue;
					lowestNode = thisNode;
				}// if (thisValue < lowestValue)
			}// if (checkVariable != -1)
		}// compareNode()
		// - - - - - - - - - - - - 
		
		if (allowDiagonal)
		{// calculate an area
			for (var x = left; x<=right; x++)
			{
				for (var y = top; y<=bottom; y++)
				{
					compareNode();
				}// for y
			}// for x
		}// if (allowDiagonal)
		else
		{// calculate in a cross
			var y = parentNode.y;
			for (var x = left; x<=right; x++)
			{
				compareNode();
			}// for x
			
			var x = parentNode.x;
			for (var y = top; y<=bottom; y++)
			{
				compareNode();
			}// for y
		}// if (!allowDiagonal)
		
		// - - - - - - - - - - - - 
		return lowestNode;
	}// findSurroundingNode()
	
	
	
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
	
	// create 2D array of Nodes to store g,h,f (leave them undefined), store x,y
	var node_array = makeNodeArray(width, height);
	// Translate collision -> cost, via a passed "getCost" function.
	defineCost(node_array, getCost);
	// select the node of (startX, startY)
	var startNode = node_array[startX][startY];
	startNode.costSoFar = 0;
	startNode.distanceToEnd = 0;
	startNode.totalCost = 0;
	var endNode = node_array[endX][endY];
	var selectedNode = startNode;
	// add selected node to "open" list
	var open_array = new Array();
	open_array.push( selectedNode );
	//close selected node
	closeNode(selectedNode);
	
	// while ("open" list has nodes  AND  selected != destination)  OR  we're just starting
	//while (open_array.length > 0  &&  selectedNode != endNode  ||  selectedNode == startNode)
	while (selectedNode != undefined  &&  selectedNode != endNode  ||  selectedNode == startNode)
	{
		//calc surrounding nodes (if not closed nor open)  &  add each to "open" list
		calcNodesAround(selectedNode, endNode, allowDiagonal);
		//select open node with the lowest "totalCost"
		selectedNode = findNode( open_array, "totalCost");
		//remove it from "open" list
		//close selected node
		closeNode(selectedNode);
	// end while
	}// while ("open" list has nodes  OR  selected != destination)
	
	// if a path was found:
	if (selectedNode == endNode)
	{
		trace("Path has been found");
		//add destination to "nav" list
		var nav_array = new Array();
		nav_array.push(selectedNode);		// add to the beginning of array
		//while selected node != starting place
		while (selectedNode != startNode)
		{
			//select surrounding node with lowest "costSoFar"  (skip uncalculated ones)
			selectedNode = findSurroundingNode( selectedNode, allowDiagonal, node_array, "costSoFar");
			
			//add that node to "nav" list
			nav_array.push(selectedNode);		// add to the beginning of array
			trace("added:  x: "+selectedNode.x+"   y: "+selectedNode.y);
		//end while
		}// while (start is not selected)
		nav_array.reverse();

		// return "nav" array of nodes
		return nav_array;
	// end if
	}// if (path was found)
	else
	{// if no path found
		return undefined;
	}// if no path found
	
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
}// getPath()